# 伪人大本营｜对外深度 Brief（完整版）

> 面向对象：外部发行专家（需要“能讲清楚、能定打法、能做判断”）
>
> 写作原则：
> - 所有硬设定以仓库权威资料为准（lore/oc/地图口径）；本 Brief 只做提炼与可传播化。
> - 传播打法按“GM 互动连载”组织（把用户从观众变成参与者）。

---

## 0. 三段式讲清楚（可直接口播）

### 0.1 30 秒（电梯版）
- **伪人大本营**是一个带 SCP/规则怪谈气质的原创世界：存在“里界”，也存在会拟态人类的“伪人”。
- **槐安公寓**是伪人最大的“训练与评估基地”：房门内可以怪，房门外必须学会像人。
- 我们用“楼长/营长”当 GM，把内容做成回合制互动：测试→分房→投票→共创→兑现→写入正史。

### 0.2 3 分钟（能让发行脑中成形）
- 世界观核心不是“怪谈吓人”，而是 **异类在夹缝里求生、学着融入、还要守规矩** 的现实隐喻；恐怖是外壳，温情与秩序是内核。
- 我们有一套非常好传播的 **七色危险等级体系**（⬜️🟦🟩🟨🟧🟥🟪），天然适合封面、工牌、档案、警报。
- 核心舞台固定在槐安公寓与周边哨站（非常电影院、桃花堂、INFUSION），因此内容可高频连载：
  - 公寓：分房、住户守则、邻居盲盒、拟态训练、考核与身份卡。
  - 哨站：城市建造/设施扩建投票、任务委托、道具/伪物交易、角色活动。
- 发行要做的不是“把设定讲完”，而是 **把入场门槛做低**：每条内容只抛出一个可参与的玩法，次日兑现形成追更。

### 0.3 10 分钟（能开宣发会）
- 这个企划的“主创脑回路”是：把一个高信息密度的 OC 世界观，改造成能长期运营的“线上跑团”。
- GM 的权力来自设定：楼长/营长本就是公寓管理者与评估者；二营长本就是哨站站长与清劣者。
- 受众会被两种情绪钩住：
  1) **确诊感**（危险等级/阵营倾向/房卡）
  2) **归属感**（“原来你也不是人”】【回家】【分到房间】）
- 内容生产遵循红线：**不准瞎编**，所有角色名/房号/机构/能力必须可追溯；否则会破坏“像真的”那种沉浸。

---

## 1. 这是什么：世界观骨架（对外可讲的那部分）

### 1.1 表界 / 里界
- **表界**：人类的现实社会。
- **里界（innerside）**：一种“不易被察觉的异空间”统称，入口叫【门】，常出现在“空间交界处”（门窗抽屉、甚至电子屏幕等）。
- 里界的东西可能很“有趣”，也可能很危险；人类通常被警告不要探索。

### 1.2 伪人是什么
- 在世界观里，“伪人”是来自里界或受里界影响的非人存在，能以各种方式拟态/学习人类。
- 伪人并非天然邪恶：有的能友好互动，有的中立，有的危险；因此需要评估与管理。
- 另有一种被定义为极度危险的伪人类型（Alternate/奥特娜特）：会模仿并替代人类继续生活。

### 1.3 七色危险等级体系（核心传播资产）
> 这套体系是“伪人大本营”的第一传播锚点：容易做成封面/工牌/档案，也容易做互动测试。

- **里界等级（空间本身）**：⬜️REALITY / 🟦NORMAL / 🟩SAFE / 🟨CAUTION / 🟧DANGER / 🟥HAZARD / 🟪MUTATION
- **里界生物等级**：🟩SAFE / 🟨CAUTION / 🟧DANGER / 🟥HAZARD
- **里界物体（伪物）等级**：🟩SAFE / 🟨CAUTION / 🟧DANGER / 🟥HAZARD

> 可视化建议：永远用“色块 + 图标 + 档案排版”表达，不要讲长段落定义。

### 1.4 关键名词：伪物、哨站、公寓
- **伪物**：来自里界的特殊物品，具有超常属性；对人类有侵蚀风险，因此被官方管控，同时也在灰色市场流通。
- **哨站**：人类与伪人的“交换点/服务点/委托点”，可以是电影院、餐厅、杂货铺等形态。
- **公寓（聚落）**：为缓解两界关系、方便登记管理而设立的伪人聚居与教育体系；伪人要学习“成为人类”。

---

## 2. 核心舞台：槐安公寓 + 周边哨站（内容可以无限生长的原因）

### 2.1 槐安公寓定位（写稿口径）
一句话：**槐安公寓是一座“给伪人住、教伪人装人、顺便筛选/评估”的大型公寓；还是渊境最大里界出入口旁的核心枢纽。**

三合一职能：
1) 住所：给伪人落脚。
2) 社会化教育与考核：学习人类、被观察、被评估，最终目标是拿到官方认可的身份证明。
3) 出入口枢纽：人流/伪人流/信息流/风险集中，既热闹也更讲规矩。

氛围关键词：
- **被看着**：温馨，但更像“有规则的温馨”。
- **低调融入**：房门外要像人。
- **楼长的存在感**：发卡、审查、处分、通告，都能合理挂到楼长名下。

### 2.2 公寓叙事的“万能流程”
对外可高频复用：
1) 新人登记（名字/物种/房号）
2) 领取槐安临时身份卡（观察期）
3) 考核/补考（拟态、社交、遵守守则）
4) 合格后获得官方身份证明（进入表界的资格）

### 2.3 404 的意义
- 404 与楼长相关，是“权力与规矩的象征房”，常见口径是“未经允许找不到/不要乱敲”。
- 传播上，404 是“世界观可信度”的门槛：不要随意写成随机怪谈房。

### 2.4 哨站网络（把“日常”变成可运营的玩法）
已明确且可对外使用的哨站：
- **非常电影院**：二营长（非常玦蝶）开设，单先生运营；是社区电影院与礼堂，也是“特殊调查业务”与清理“坏朋友”的节点。
- **桃花堂**：大型哨站之一，明面是万能杂货铺，暗面连接拍卖会与委托体系。
- **花园餐厅 INFUSION**：亚契·谜思开设，兼具餐饮、栽培、宠物与“个人藏品展示”的博物馆属性。

> 运营价值：哨站天然适合“建造/扩建投票”“菜单共创”“道具上新”“委托任务”。

---

## 3. 关键角色（宣发最先抓住的“主角群”）

> 下面这批角色用于“对外讲清楚”和“投放首周素材”，优先级最高。

### 3.1 营长 / 楼长（安诺涅）｜槐安公寓的 GM 权威
- 身份：伪人论坛《伪人大本营》管理者（营长），也是槐安公寓楼长；自称“我们”，喜欢把住户叫“假人（家人）”。
- 视觉：银色低马尾、黄紫相间的眼睛；“眼睛”元素遍布（发丝/蝴蝶/装饰）。
- 性格口吻：谜语人外表 + 隐藏款乐子人；愉悦时带“～”；能打破第四面墙。
- 能力：以“眼”的概念存在，可夺走/引爆视力；可通过“眼线”复生，几乎全世界都在其目所能及之内。
- 传播价值：公告口吻、档案口吻、分房/发卡/处分/揭秘的权力来源；适合作为账号人格。

### 3.2 非常玦蝶（二营长）｜哨站站长 + 清劣者
- 身份：非常电影院哨站站长；伪人大本营二营长；顶尖清劣者。
- 视觉：粉发少女形态；双手血红（赫手）；高冷御姐气质。
- 设定钩子：没有视觉（眼睛是伪装），但拥有强感知；赫手用于抹除违规者。
- 传播价值：适合做“补考/抓违规/拟态翻车大赏”的主持人；语气更硬、更有惩戒感。

### 3.3 赫卡忒（Hecate）｜🟩SAFE 的“精致仿生人”
- 类型：类人型；🟩SAFE。
- 视觉：炭黑皮肤、蓝色水晶质感头发、四臂、无眼结构但拥有视觉；随身伪物“锁与钥”。
- 伪物：锁与钥可隔离封闭空间/开启额外小空间里界（“赫卡忒的房间”⬜️REALITY），锚定在槐安 405。
- 传播价值：强视觉符号（四臂、锁钥、黑蓝配色）；适合做“绝对防御/但私人空间被锁”的反差梗。

### 3.4 化而为（Transform）｜“史莱姆娘”+ 变形修补
- 项目等级：SAFE/CAUTION（文本中同时出现）。
- 视觉：凝胶状史莱姆；常态可拟态为白发红瞳和服少女，持红伞。
- 能力：分解穿梭、拟态模仿、修补复原；心理年龄近似幼童，亲人类。
- 传播价值：最适合做“共创悬赏”（材质/形态/穿搭）与“拟态找茬”；也最适合“温馨怪谈”的情绪支点。

### 3.5 西瓜人｜“想当人类”的公司董事长
- 身份：西瓜公司董事长；槐安 606。
- 设定钩子：对成为人类有执念；会赠西瓜汁；帮助人类生存会更接近“人”。
- 传播价值：荒诞温情；商业梗（公司全球第三）；适合做“物资补给/快递开箱/哨站赞助”。

### 3.6 小赤帽（赤）｜“童话残骸”的清洁工
- 身份：槐安 609；负责公寓卫生清洁。
- 视觉：白色人偶 + 狼尾与爪；影子是一只巨狼且可能提前行动。
- 传播价值：规则怪谈味最浓；适合做“住户守则/深夜走廊/别回应敲门”的氛围内容。

### 3.7 大夜夜｜808 的“异次元衣柜”与高定店
- 身份：槐安 808；夜幕高定店主。
- 设定钩子：衣柜联通🟦NORMAL 的额外空间（像车库大小）。
- 传播价值：毒舌大小姐的人设利于“吐槽式互动”；适合做“伪物珠宝化/礼仪指导/换装投票”。

### 3.8 涂改（Tipp-Ex）｜强迫症“抹除错误”的少年
- 设定钩子：看到错误/污渍/痘痘就想“涂改”；能力【归白】可把物体抹成白色平面。
- 传播价值：适合做“公寓公告：谁把走廊写脏了”与“错误字迹消失”的短怪谈。

### 3.9 X（生骸·X）｜规则体“生命”概念的幼童
- 设定钩子：规则体；权能近似“逆转熵变/嬗变”；接触恶意者会被植物化。
- 传播价值：适合做“规则怪谈式入场须知”（三条准则）；也能做“公寓花坛里那个孩子”的温柔恐怖。

---

## 4. 传播方法论：为什么我们要用 GM 互动连载

### 4.1 核心难题
- 世界观与 OC 信息密度极高，直接讲会信息过载。
- 传统宣发会把观众当“读者”；我们要把观众当“玩家”。

### 4.2 “空想森林”式打法（本项目的迁移版本）
一句话：**把每条内容做成一个可参与的玩法，而不是一次性介绍。**

常用玩法（可复用成栏目）：
- **身份贴标**：危险等级/阵营倾向测试（评论生成你的“工牌/房卡/档案编号”）。
- **场景带入**：公寓招租/分房（评论填“物种+怪癖”，GM 发钥匙）。
- **玩梗共创**：拟态翻车/AI 崩坏图（Bug 变 Feature）。
- **社区决策**：哨站扩建/设施投票（观众像股东一样决定建什么）。
- **RPG 选择**：出村礼包/四选一（用道具承载设定）。
- **设计悬赏**：为角色设计新形态（UGC → 正史化）。

### 4.3 黄金循环（每条都要闭环）
1) 钩子（封面即指令）
2) 互动（评论做选择）
3) 兑现（次日揭晓/发放/更新）
4) 正史化（把高赞 UGC 写进世界观，形成“我参与了”的归属感）

---

## 5. 首周内容（发行同学可据此排期/选渠道）

> 参考分镜脚本：`伪人大本营推广内容分镜.md`

- 01 身份钩子｜危险等级入职测试
- 02 场景带入｜槐安公寓招租/分房
- 03 玩梗共创｜拟态失败大赏
- 04 设计投票｜哨站扩建蓝图
- 05 生存选择｜出村礼包
- 06 设计悬赏｜化而为新形态

建议节奏：先用 01/02 建立身份与归属，再用 03/04/05/06 提升参与与共创深度。

---

## 6. 文案与视觉风格指南（给发行把控一致性）

### 6.1 文案口吻（长期稳定）
- 第一人称优先用“楼长/营长/大本营公告”。
- 半官方、半玩梗：像泄露档案/公告栏便签/蓝图招标，但语言要“人味”。
- 常用黑话：拟态、掉马、里界、门、收容、哨站、伪物、危险色谱。

### 6.2 视觉母版（优先选这几类）
- 档案/绝密文件泄露（红章、烧焦边、拼贴）。
- 色谱/工牌/身份卡（七色等级）。
- 公寓公告栏（便签、门牌、钥匙串）。
- 蓝图/施工图（哨站扩建投票）。
- 监控录像质感（拟态翻车/Glitch）。

### 6.3 红线（必须守）
- 角色名/房号/设定不可凭空新增或写错。
- 404 不能随意乱写（它是权力符号）。
- 槐安不是“完全放飞的安全屋”，它是训练与评估体系。

---

## 7. 给发行专家的协作清单（你可以怎么帮我们）

### 7.1 渠道与内容匹配（建议）
- 小红书：主阵地（测试/投票/四选一/共创最适配）。
- B 站：中长视频“世界观入门 + 角色档案 + 连载复盘”（用档案叙事）。
- 微博：事件化扩散（“公告/通缉/紧急通告/封条”）。

### 7.2 发行要盯的不是“讲解”，而是“参与率”
- 每条都要有明确 CTA；每条都要能兑现。
- 关注评论质量与二创潜力（能否形成模板与梗）。

### 7.3 你需要向我们要的东西（尽早对齐）
- 可公开的角色清单（哪些 OC 图可投放、是否需要署名/授权）。
- 账号的人格与禁区（楼长语气边界、二营长语气边界）。
- 兑现产能（次日揭晓能做到什么程度：一张图/一段公告/一张房卡）。

---

## 8. 附：核心资料索引（权威来源）
- 世界观圣经：`project/世界观资料/伪人大本营_699871/伪人大本营_lore.md`
- 阵营问卷：`project/世界观资料/伪人大本营_699871/伪人大本营_description.md`
- 营长档案：`project/世界观资料/伪人大本营_699871/oc/7649617_营长/7649617_营长.md`
- 二营长档案：`project/世界观资料/伪人大本营_699871/oc/7651752_非常玦蝶#二营长/7651752_非常玦蝶#二营长.md`
- 槐安公寓口径：`project/企划の宣传/伪人大本营/03_map/槐安公寓/槐安公寓_详细说明_可读版.md`
- 槐安房号对照：`project/企划の宣传/伪人大本营/03_map/槐安公寓/槐安公寓_房间-OC对照表.md`
- 首周分镜：`伪人大本营推广内容分镜.md`
- 推广总方案：`伪人大本营推广方案.md`

