/* eslint-disable */
// 伪人大本营｜OC 手工 Meta（v1）
// - 目标：提供“可手动维护”的结构化信息，用于筛选/徽标/槐安公寓住户页签。
// - 维护方式：按 oc_id 追加/修改字段即可（oc_id 可在 oc.html 卡片 data-id 中找到）。
(function () {
  const META = {
    // --- 槐安公寓：关键角色 ---
    "7649617": {
      display_name: "营长",
      danger_level: "hazard",
      danger_note: "能力：可夺走/引爆拥有眼睛生物的视力；受致命伤可在眼线处复生（眼线遍布全球）。",
      factions: ["伪人大本营", "槐安公寓"],
      human_attitude: "neutral",
      human_attitude_note: "自述“守序中立”，以管理/观察为主；遭遇威胁时可强力处置。",
      roles: ["楼长", "论坛创建者"],
      residence: { building: "槐安公寓", room: "404", floor: 4, note: "未经允许找不到这间房间" },
    },
    "7651752": {
      display_name: "非常玦蝶#二营长",
      danger_level: "danger",
      danger_note: "能力：赫手可“抹除”违规者/发现自己的“食物”；具强感知（近似360°）。",
      factions: ["非常电影院", "哨站", "伪人大本营"],
      human_attitude: "hostile",
      human_attitude_note: "对“食物/违规者”倾向敌对；对熟人可能合作。",
      roles: ["二营长", "清劣者", "哨站站长"],
      residence: { building: "unknown" },
    },

    // --- 槐安公寓：住户（房号） ---
    "7672104": { display_name: "『我深深的破碎』", danger_level: "danger", danger_note: "大范围崩解时，记录显示目击者/接近者会“失踪”。", factions: ["槐安公寓"], human_attitude: "neutral", roles: ["住户"], residence: { building: "槐安公寓", room: "101", floor: 1 } },
    "7626697": { display_name: "绊#得到之爱", danger_level: "danger", danger_note: "自述：病娇/控制欲强，习惯使用折叠刀杀人；住进公寓后更温和。", factions: ["槐安公寓"], human_attitude: "neutral", human_attitude_note: "对公寓住户会送礼/社交；对“被爱/控制”目标可能极端。", roles: ["住户"], residence: { building: "槐安公寓", room: "104", floor: 1 } },
    "8238065": { display_name: "云蓝#幼年", danger_level: "danger", danger_note: "以手偶为“共犯”实施杀害并逃亡；具强烈认知/身份错位倾向。", factions: ["槐安公寓"], human_attitude: "hostile", roles: ["住户"], residence: { building: "槐安公寓", room: "105", floor: 1 } },
    "8029292": { display_name: "puzzle#fragmentary", danger_level: "caution", danger_note: "原文：威胁等级=CAUTION?；能力可导致目标“存在性解离/崩毁成拼图碎片”。", factions: ["槐安公寓"], human_attitude: "neutral", roles: ["住户"], residence: { building: "槐安公寓", room: "106", floor: 1 } },
    "8276582": { display_name: "H3#黑伞", danger_level: "danger", danger_note: "伞内出现“彩虹手”可将人拖入伞中消失；情绪/记忆不稳定。", factions: ["槐安公寓"], human_attitude: "neutral", roles: ["住户"], residence: { building: "槐安公寓", room: "108", floor: 1 } },
    "8046770": { display_name: "“格弭门”#瘟疫与医生", danger_level: "hazard", danger_note: "设定为行走的“瘟疫/病主”，与大瘟疫事件关联；对外基本无交流。", factions: ["槐安公寓"], human_attitude: "neutral", roles: ["住户"], residence: { building: "槐安公寓", room: "112", floor: 1, note: "登记表为“瘟疫医生”" } },
    "7928862": { display_name: "春山 抚子#伪人版自设（迫真）", danger_level: "safe", danger_note: "猫形拟态、学习模仿；自述为“无害类型”。", factions: ["槐安公寓"], human_attitude: "neutral", roles: ["住户"], residence: { building: "槐安公寓", room: "114", floor: 1 } },

    "8286150": { display_name: "𝔻𝕣.𝔸\\𝕔𝕙𝕖𝕄𝕚𝕤𝕥#亚契·谜思", danger_level: "caution", danger_note: "补充档案：安全评级=🟨CAUTION（高智能、创造生命的潜在隐患）。", factions: ["槐安公寓", "绿洲", "INFUSION"], human_attitude: "neutral", human_attitude_note: "对人类偏研究/观察取向，描述为“较为友好”。", roles: ["研究员"], residence: { building: "槐安公寓", room: "201/202", floor: 2, note: "登记表：复合实验室（亚契·谜思&荆千棘）" } },
    "8294643": { display_name: "荆千棘#Thorns For Me", danger_level: "safe", danger_note: "描述为温和善良的“助手/盆栽激活体”。", factions: ["槐安公寓"], human_attitude: "friendly", roles: ["住户", "助手"], residence: { building: "槐安公寓", room: "201/202", floor: 2, note: "登记表：复合实验室（亚契·谜思&荆千棘）" } },
    "8170736": { display_name: "迷迭香#伪人设", danger_level: "danger", danger_note: "自述存在暴力倾向/理智不稳；长时间对视与情绪波动可能导致风险。", factions: ["槐安公寓"], human_attitude: "neutral", roles: ["住户"], residence: { building: "槐安公寓", room: "205", floor: 2 } },

    "7773303": { display_name: "化而为（常态）", danger_level: "caution", danger_note: "项目等级：SAFE/CAUTION；友好但具穿梭/拟态/渗透能力，存在“过度接触”警告。", factions: ["槐安公寓"], human_attitude: "friendly", roles: ["住户"], residence: { building: "槐安公寓", room: "302", floor: 3 } },
    "7789659": { display_name: "江小楠(22号)", danger_level: "caution", danger_note: "可借助电子游戏/书本力量将人打晕（非致命描述）。", factions: ["槐安公寓"], human_attitude: "neutral", roles: ["住户"], residence: { building: "槐安公寓", room: "322", floor: 3 } },

    "7935709": {
      display_name: "viole（简介有词条）",
      danger_level: "caution",
      danger_note: "原文：危险程度=中。",
      factions: ["槐安公寓"],
      human_attitude: "friendly",
      roles: ["住户"],
      residence: { building: "槐安公寓", room: "401", floor: 4 },
    },
    "7708717": { display_name: "祝可可#奔赴绚烂", danger_level: "safe", danger_note: "文本为书信体，未描述危险能力；按普通住户处理。", factions: ["槐安公寓"], human_attitude: "friendly", roles: ["住户"], residence: { building: "槐安公寓", room: "403", floor: 4, note: "登记表为“可可”" } },
    "8285653": { display_name: "ℍ𝕖𝕔𝕒𝕥𝕖#RES-44-长夜", danger_level: "safe", danger_note: "原文：安全评级=🟩SAFE（无主动攻击/破坏欲望）。", factions: ["槐安公寓"], human_attitude: "friendly", roles: ["住户"], residence: { building: "槐安公寓", room: "405", floor: 4 } },
    "7749069": { display_name: "赫木祀夜 #猎人/0-04-66小王子", danger_level: "hazard", danger_note: "可控孢子同化（半天级别）+ 精神污染/幻觉/菌丝网络；原文提示对恶伪人痛恨。", factions: ["槐安公寓"], human_attitude: "friendly", human_attitude_note: "对人类与善良伪人友好，对作恶伪人极端敌对。", roles: ["住户"], residence: { building: "槐安公寓", room: "406", floor: 4 } },
    "8161283": { display_name: "恶堕莉莉丝", danger_level: "danger", danger_note: "原文：危险程度🌟🌟🌟🌟；憎恨人类，“惹她会付出代价”。", factions: ["槐安公寓"], human_attitude: "hostile", roles: ["住户"], residence: { building: "槐安公寓", room: "408", floor: 4 } },
    "7659673": { display_name: "“繁星夜”#Bubble Gum（泡泡）", danger_level: "safe", danger_note: "自述喜欢“好人类”和公寓住户；无攻击性描述。", factions: ["槐安公寓"], human_attitude: "friendly", roles: ["住户"], residence: { building: "槐安公寓", room: "409", floor: 4 } },
    "8054298": { display_name: "月汐#伪人柚", danger_level: "hazard", danger_note: "能力：吞噬一切物体；吞噬智慧生命可获得记忆；自述目标为“模仿/代替”人类个体。", factions: ["槐安公寓"], human_attitude: "hostile", roles: ["住户"], residence: { building: "槐安公寓", room: "410", floor: 4 } },

    "7824890": { display_name: "科拉松#人监之心", danger_level: "hazard", danger_note: "概念体：可同步/操控心跳乃至令心脏自毁；可交换血液/吸收邪念。", factions: ["槐安公寓", "人监"], human_attitude: "friendly", human_attitude_note: "对住客表现为温柔善于倾听（但能力上限极高）。", roles: ["住户"], residence: { building: "槐安公寓", room: "502", floor: 5 } },
    "8034281": { display_name: "“无名卿”#疯狂的尽头是平静", danger_level: "danger", danger_note: "常态友善；“混乱状态”需远离，存在噩梦/盯上目标的风险。", factions: ["槐安公寓"], human_attitude: "neutral", human_attitude_note: "对“人”平静友善，但状态波动时具强风险。", roles: ["住户"], residence: { building: "槐安公寓", room: "503", floor: 5 } },
    "7704334": { display_name: "西西(伪人设)", danger_level: "caution", danger_note: "恶魔之女设定，存在“触发关键词→恶魔人格”切换（以暴制暴）。", factions: ["槐安公寓"], human_attitude: "friendly", human_attitude_note: "对普通人/弱者温柔、治愈取向；对威胁/邪恶者冷酷。", roles: ["住户"], residence: { building: "槐安公寓", room: "504", floor: 5 } },
    "8103883": { display_name: "特洛菲&洛洛#人监之“口”", danger_level: "hazard", danger_note: "可分泌强酸溶解表界98%物质；以“吃下供给人监”为使命。", factions: ["槐安公寓", "人监"], human_attitude: "hostile", roles: ["住户"], residence: { building: "槐安公寓", room: "506", floor: 5 } },
    "8119536": { display_name: "Josselin.#【傀儡006】", danger_level: "safe", danger_note: "原文：危险等级=safe。", factions: ["槐安公寓"], human_attitude: "friendly", roles: ["住户"], residence: { building: "槐安公寓", room: "510", floor: 5 } },
    "6587389": { display_name: "Joschmitt.#设定补充", danger_level: "caution", danger_note: "设定补充稿本体描述偏抒情；未给出明确危险等级，按不明超自然体保守评为 CAUTION。", factions: ["槐安公寓"], human_attitude: "neutral", roles: ["住户"], residence: { building: "槐安公寓", room: "510", floor: 5, note: "同房间的设定补充稿" } },

    "7762640": { display_name: "dust imprison", danger_level: "danger", danger_note: "寄生读取记忆、逐步取代人格；已知攻击手段包含“环境同化/侵蚀”。", factions: ["槐安公寓", "斯卡情报网"], human_attitude: "hostile", roles: ["住户"], residence: { building: "槐安公寓", room: "603", floor: 6 } },
    "7759436": { display_name: "Li Yuan", danger_level: "caution", danger_note: "情报网局长（灵魂体）；以情报交换“灵魂标本”等，偏交易型风险。", factions: ["槐安公寓", "斯卡情报网"], human_attitude: "neutral", roles: ["住户"], residence: { building: "槐安公寓", room: "604", floor: 6 } },
    "7656934": { display_name: "西瓜人", danger_level: "safe", danger_note: "设定为“帮助人类生存”的规则体；对人类很友好。", factions: ["槐安公寓"], human_attitude: "friendly", roles: ["住户"], residence: { building: "槐安公寓", room: "606", floor: 6 } },
    "7642448": { display_name: "白色甜蜜#澪秋照", danger_level: "unknown", danger_note: "当前资料仅有外观 tag（无行为/能力描述），无法推断。", factions: ["槐安公寓"], human_attitude: "unknown", roles: ["住户"], residence: { building: "槐安公寓", room: "608", floor: 6, note: "登记表为“vv/白色甜蜜”" } },
    "7692255": { display_name: "小赤帽", danger_level: "caution", danger_note: "童话残骸设定：影子为巨狼、具非人特征；未描述主动攻击。", factions: ["槐安公寓"], human_attitude: "neutral", roles: ["住户", "清洁"], residence: { building: "槐安公寓", room: "609", floor: 6 } },
    "8079957": { display_name: "卜焕汣#伪人设", danger_level: "caution", danger_note: "触须有毒、藤蔓可攻防；兼任桃花堂负责人。", factions: ["槐安公寓", "桃花堂"], human_attitude: "neutral", roles: ["住户"], residence: { building: "槐安公寓", room: "610", floor: 6, note: "登记表为“桃花不换酒”" } },
    "8086301": { display_name: "吾思", danger_level: "danger", danger_note: "能力：记忆干扰/篡改；茶汤可致“记忆迷雾”，并有秘密外泄风险。", factions: ["槐安公寓", "桃花堂"], human_attitude: "neutral", roles: ["住户"], residence: { building: "槐安公寓", room: "611", floor: 6, note: "登记表为“蠹鱼不食断肠诗”" } },

    "7698459": { display_name: "渡潵", danger_level: "caution", danger_note: "影躯/记忆复刻/追踪信标；人格碎片化风险。", factions: ["槐安公寓", "斯卡情报网"], human_attitude: "neutral", roles: ["住户"], residence: { building: "槐安公寓", room: "702", floor: 7 } },
    "7654625": { display_name: "零#84dd", danger_level: "safe", danger_note: "记录员/虚拟体，能力偏情报记录与回溯；本体脆弱。", factions: ["槐安公寓", "斯卡情报网"], human_attitude: "neutral", roles: ["住户"], residence: { building: "槐安公寓", room: "703", floor: 7 } },
    "7751287": { display_name: "百合#58c7", danger_level: "safe", danger_note: "花灵化形，偏情报/花店中立服务；无主动攻击描述。", factions: ["槐安公寓", "斯卡情报网"], human_attitude: "friendly", roles: ["住户"], residence: { building: "槐安公寓", room: "705", floor: 7 } },

    "8115714": { display_name: "阴暗邪恶大夜夜", danger_level: "caution", danger_note: "其衣柜联通里界评级为🟦NORMAL；本人经营伪物饰品/定制等，未给出个体危险评级。", factions: ["槐安公寓"], human_attitude: "neutral", roles: ["住户"], residence: { building: "槐安公寓", room: "808", floor: 8 } },

    "8227821": { display_name: "伽纳罗丝", danger_level: "caution", danger_note: "本体为可操纵血液的伪人；对人类无敌意但会吸食血液（不致死，仍有风险）。", factions: ["槐安公寓"], human_attitude: "neutral", roles: ["住户"], residence: { building: "槐安公寓", room: "904", floor: 9 } },
    "8108235": { display_name: "笑颜#咲", danger_level: "hazard", danger_note: "诱导开门/潜入；情绪污染可致“无法控制的笑意→面部肌肉坏死”。", factions: ["槐安公寓"], human_attitude: "hostile", roles: ["住户"], residence: { building: "槐安公寓", room: "909", floor: 9 } },

    "8104647": { display_name: "陆玖#伪人设", danger_level: "hazard", danger_note: "认知安全风险：凝视/镜面/定义本质等可能触发防御协议或概念验证行为。", factions: ["槐安公寓"], human_attitude: "neutral", roles: ["住户"], residence: { building: "槐安公寓", room: "5003", floor: 50 } },

    // --- 槐安公寓：特殊居住地（无固定房号） ---
    "7699781": { display_name: "X#主线", danger_level: "hazard", danger_note: "规则体：违背准则可触发“植物化”惩戒；官方告诫“绝对不要接近”。", factions: ["槐安公寓"], human_attitude: "neutral", human_attitude_note: "行为逻辑偏孩童式善意，但规则惩戒不可逆且极危险。", roles: ["住户"], residence: { building: "槐安公寓", room: null, floor: null, note: "住处不固定：花坛/阳台/花盆等" } },
    "7802690": { display_name: "Aurora#「蚀光暖浆」", danger_level: "caution", danger_note: "情感镜像/寂静吞噬（共情反射），可被动映照成他人思念对象；具保护性道具能力。", factions: ["槐安公寓"], human_attitude: "friendly", roles: ["住户"], residence: { building: "槐安公寓", room: null, floor: null, note: "地下室锅炉房旁废弃积水池" } },
    "8019822": { display_name: "墨水夜#伪人大本营", danger_level: "safe", danger_note: "原文：不会伤害人类（食物为史莱姆）。", factions: ["槐安公寓"], human_attitude: "neutral", roles: ["住户"], residence: { building: "槐安公寓", room: null, floor: null, note: "公寓水池" } },

    // --- 登记表外补充（房号明确） ---
    "7694642": { display_name: "Foleyrne&Cirit", danger_level: "caution", danger_note: "共生体/装作人类考核未通过；能力未详细描述，按不明伪人保守评为 CAUTION。", factions: ["槐安公寓"], human_attitude: "neutral", roles: ["住户"], residence: { building: "槐安公寓", room: "601", floor: 6 } },

    // --- 登记表外补充（非标准房号） ---
    "7690964": { display_name: "绫份#青", danger_level: "danger", danger_note: "格斗术大师/异常抗性高，具伪物长刀增幅；偏物理清除型战力。", factions: ["槐安公寓"], human_attitude: "friendly", human_attitude_note: "对同伴有隐性保护倾向。", roles: ["住户"], residence: { building: "槐安公寓", room: "阁楼", floor: null } },
  };

  const HUAIAN = {
    building: "槐安公寓",
    rooms: [
      { room: "101", occupants: [{ oc_id: "7672104", label: "『我深深的破碎』" }] },
      { room: "102", occupants: [{ label: "落嵛" }], missing: true },
      { room: "103", occupants: [{ label: "zamtala" }], missing: true },
      { room: "104", occupants: [{ oc_id: "7626697", label: "绊" }] },
      { room: "105", occupants: [{ oc_id: "8238065", label: "云蓝" }] },
      { room: "106", occupants: [{ oc_id: "8029292", label: "puzzle" }] },
      { room: "108", occupants: [{ oc_id: "8276582", label: "H3#黑伞" }] },
      { room: "112", occupants: [{ oc_id: "8046770", label: "瘟疫医生（格弭门）" }] },
      { room: "114", occupants: [{ oc_id: "7928862", label: "春山抚子" }] },
      { room: "201", occupants: [{ oc_id: "8286150", label: "亚契·谜思" }, { oc_id: "8294643", label: "荆千棘" }], note: "登记表：201/202 复合实验室" },
      { room: "202", occupants: [{ oc_id: "8286150", label: "亚契·谜思" }, { oc_id: "8294643", label: "荆千棘" }], note: "登记表：201/202 复合实验室" },
      { room: "205", occupants: [{ oc_id: "8170736", label: "迷迭香" }] },
      { room: "207", occupants: [{ label: "cresent" }], missing: true },
      { room: "209", occupants: [{ label: "涂改（Tipp-Ex）" }], missing: true, note: "资料存在“209/XXXX”不一致" },
      { room: "302", occupants: [{ oc_id: "7773303", label: "化而为" }] },
      { room: "303", occupants: [{ label: "伊露" }], missing: true },
      { room: "304", occupants: [{ label: "Jane Ryangell" }], missing: true },
      { room: "306", occupants: [{ label: "玄弦若离" }], missing: true },
      { room: "310", occupants: [{ label: "行粥" }], missing: true },
      { room: "322", occupants: [{ oc_id: "7789659", label: "江小楠" }] },
      { room: "401", occupants: [{ oc_id: "7935709", label: "viole" }] },
      { room: "402", occupants: [{ label: "奥特娜特" }], missing: true },
      { room: "403", occupants: [{ oc_id: "7708717", label: "可可（祝可可）" }] },
      { room: "404", occupants: [{ oc_id: "7649617", label: "营长" }] },
      { room: "405", occupants: [{ oc_id: "8285653", label: "赫卡忒" }] },
      { room: "406", occupants: [{ oc_id: "7749069", label: "赫木祀夜" }] },
      { room: "408", occupants: [{ oc_id: "8161283", label: "恶堕莉莉丝" }] },
      { room: "409", occupants: [{ oc_id: "7659673", label: "泡泡（Bubble Gum）" }] },
      { room: "410", occupants: [{ oc_id: "8054298", label: "月汐" }] },
      { room: "502", occupants: [{ oc_id: "7824890", label: "科拉松" }] },
      { room: "503", occupants: [{ oc_id: "8034281", label: "“无名卿”" }] },
      { room: "504", occupants: [{ oc_id: "7704334", label: "西西" }] },
      { room: "505", occupants: [{ label: "Yami&JOmoys" }], missing: true },
      { room: "506", occupants: [{ oc_id: "8103883", label: "特洛菲&洛洛" }] },
      { room: "510", occupants: [{ oc_id: "8119536", label: "傀儡006号（Josselin.）" }, { oc_id: "6587389", label: "Joschmitt.（设定补充）" }] },
      { room: "517", occupants: [{ label: "赫敏格兰芬多" }], missing: true },
      { room: "601", occupants: [{ oc_id: "7694642", label: "Foleyrne&Cirit" }] },
      { room: "603", occupants: [{ oc_id: "7762640", label: "dust imprison" }] },
      { room: "604", occupants: [{ oc_id: "7759436", label: "Li Yuan" }] },
      { room: "606", occupants: [{ oc_id: "7656934", label: "西瓜人" }] },
      { room: "607", occupants: [{ label: "莓可酱" }], missing: true },
      { room: "608", occupants: [{ oc_id: "7642448", label: "vv/白色甜蜜" }] },
      { room: "609", occupants: [{ oc_id: "7692255", label: "小赤帽" }] },
      { room: "610", occupants: [{ oc_id: "8079957", label: "桃花不换酒（卜焕汣）" }] },
      { room: "611", occupants: [{ oc_id: "8086301", label: "蠹鱼不食断肠诗（吾思）" }] },
      { room: "628", occupants: [{ label: "七点半" }], missing: true },
      { room: "702", occupants: [{ oc_id: "7698459", label: "渡潵" }] },
      { room: "703", occupants: [{ oc_id: "7654625", label: "零" }] },
      { room: "705", occupants: [{ oc_id: "7751287", label: "百合" }] },
      { room: "808", occupants: [{ oc_id: "8115714", label: "大夜夜" }] },
      { room: "904", occupants: [{ oc_id: "8227821", label: "伽纳罗丝" }] },
      { room: "909", occupants: [{ oc_id: "8108235", label: "笑颜" }] },
      { room: "1301", occupants: [{ label: "绯红晴（似乎不常住）" }], missing: true },
      { room: "1904", occupants: [{ label: "倪蒂亚" }], missing: true },
      { room: "5003", occupants: [{ oc_id: "8104647", label: "陆玖" }] },
      { room: "阁楼", occupants: [{ oc_id: "7690964", label: "绫份" }] },
    ],
    specials: [
      { label: "花坛/花盆/阳台（无固定房号）", occupants: [{ oc_id: "7699781", label: "X" }] },
      { label: "地下室锅炉房旁积水池（无固定房号）", occupants: [{ oc_id: "7802690", label: "Aurora" }] },
      { label: "公寓水池（无固定房号）", occupants: [{ oc_id: "8019822", label: "墨水夜" }] },
    ],
    sources: [
      "project/企划の宣传/伪人大本营/03_map/槐安公寓/槐安公寓_房间-OC对照表.md",
      "project/世界观资料/伪人大本营_699871/lore/worldview/*楼.md",
      "project/世界观资料/伪人大本营_699871/oc/**",
    ],
  };

  window.PSEUDO_BASECAMP_OC_META_VERSION = 1;
  window.PSEUDO_BASECAMP_OC_META = META;
  window.PSEUDO_BASECAMP_HUAIAN = HUAIAN;
})();
